/*******************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
** This file is part of the OfficeViewer project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/


#pragma once

#include "documentproviderglobal.h"
#include <atomic>
#include <QFileInfo>
#include <QImage>
#include <QMap>
#include <QMutex>
#include <QObject>
#include <QThreadPool>

class ImagesCache;
class ExportedCache;

class DOCUMENTPROVIDER_EXPORT DocumentCache : public QObject
{
    Q_OBJECT

public:
    ~DocumentCache();

    /// @note Zoom and tile rect are not counted for page image
    bool loadImage(const QString &fileId, int pageNumber, const QSize &canvasSize, const QRect &rectTile = QRect(), qreal zoom = 1.0);
    /// @note Zoom and tile rect are not counted for page image
    void insertImage(const QString &fileId, int pageNumber, const QImage &image, const QRect &rectTile = QRect(), qreal zoom = 1.0);

    bool loadExportedDoc(const QString &fileId, const QString &pathExportedDoc, const QString &format = "pdf");
    void insertEportedDoc(const QString &fileId, const QString &pathExportedDoc, const QString &format = "pdf");

    void calculateChecksum(const QString &filePath);

    static DocumentCache *instance();

signals:
    void imageLoaded(const QString &fileId, int pageNumber, const QImage &image, const QRect &rectTile, qreal zoom);
    void documentExported(const QString &pathExportedDoc, const QString format, bool status);
    void checksumCalculated(const QString &filePath, const QByteArray &checksum);

private:
    DocumentCache(QObject *parent = nullptr);

private:
    ImagesCache *m_pageCache;
    ImagesCache *m_tileCache;
    ExportedCache *m_exportedCache;
};
