################################################################################
##
## SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
## SPDX-License-Identifier: BSD-3-Clause
## This file is part of the OfficeViewer project.
##
## Redistribution and use in source and binary forms,
## with or without modification, are permitted provided
## that the following conditions are met:
##
## * Redistributions of source code must retain the above copyright notice,
##   this list of conditions and the following disclaimer.
## * Redistributions in binary form must reproduce the above copyright notice,
##   this list of conditions and the following disclaimer
##   in the documentation and/or other materials provided with the distribution.
## * Neither the name of the copyright holder nor the names of its contributors
##   may be used to endorse or promote products derived from this software
##   without specific prior written permission.
##
## THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
## AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
## THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
## FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
## IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
## FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
## OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
## PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
## LOSS OF USE, DATA, OR PROFITS;
## OR BUSINESS INTERRUPTION)
## HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
## WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
## (INCLUDING NEGLIGENCE OR OTHERWISE)
## ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
## EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
##
################################################################################


TEMPLATE = lib
TARGET = documentprovider
TARGET = $$qtLibraryTarget($$TARGET)

CONFIG += qt create_pc create_prl link_pkgconfig

SOURCES += \
    src/documentprovider.cpp \
    src/documentcache.cpp \
    src/imagescache.cpp \
    src/exportedcache.cpp \
    src/debug.cpp \
    src/basedocument.cpp \
    src/basepage.cpp \
    src/baseannotation.cpp

PUBLIC_HEADERS = \
    src/documentprovider.h \
    src/documentproviderglobal.h \
    src/documentcache.h \
    src/imagescache.h \
    src/exportedcache.h \
    src/debug.h \
    src/basedocument.h \
    src/basepage.h \
    src/basebookmark.h \
    src/baseannotation.h


HEADERS += \
    $$PUBLIC_HEADERS 

DEFINES += \
    DOCUMENTPROVIDER_BUILD_LIBRARY

target.path = $$[QT_INSTALL_LIBS]

develheaders.path = /usr/include/$$TARGET
develheaders.files = $$PUBLIC_HEADERS

pkgconfig.path = $$[QT_INSTALL_LIBS]/pkgconfig
pkgconfig.files = $$[QT_INSTALL_LIBS]/pkgconfig/documentprovider.pc

QMAKE_PKGCONFIG_NAME = $$TARGET
QMAKE_PKGCONFIG_VERSION = $$VERSION
QMAKE_PKGCONFIG_DESCRIPTION = Header files for documentprovider plugins
QMAKE_PKGCONFIG_LIBDIR = $$target.path
QMAKE_PKGCONFIG_INCDIR = $$develheaders.path
QMAKE_PKGCONFIG_DESTDIR = pkgconfig
QMAKE_PKGCONFIG_REQUIRES = Qt5Core

INSTALLS += target develheaders pkgconfig
