/*******************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
** This file is part of the OfficeViewer project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/


import QtQuick 2.0
import Sailfish.Silica 1.0

Item {
    id: root

    readonly property bool isGridMode: fileListModel.rowCount > documentsView.singleCoumnLimit

    readonly property bool isVertical: __cover.isPortrait

    readonly property alias __documentsView: root

    SilicaGridView {
        id: documentsView

        readonly property int singleCoumnLimit: 3
        readonly property int prefferedColumnCount: root.isVertical ? 2 : 3

        anchors {
            fill: parent
        }

        layer.enabled: true
        layer.effect: OpacityRampEffect {
            direction: OpacityRamp.TopToBottom
            sourceItem: documentsView
            slope: 4.0
            offset: __cover.isPortrait ? 0.5 : 0.42
        }

        model: fileListModel

        cellWidth: root.isGridMode
                   ? documentsView.width / documentsView.prefferedColumnCount
                   : documentsView.width

        cellHeight: (root.isGridMode ? Theme.dp(120)
                                     : Theme.dp(76)) + Theme.paddingSmall

        delegate: CoverDocumentDelegate {}
    }

    Component.onCompleted: {
        __cover.actionsEnable = true
    }

    Component.onDestruction: {
        __cover.actionsEnable = false
    }
}
