# OfficeViewer

This project provides an example using libreoffice to open documents.

The source code of the project is provided under
[the license](LICENSE.BSD-3-CLAUSE.md),
that allows it to be used in third-party applications.

The [contributor agreement](CONTRIBUTING.md)
documents the rights granted by contributors to the Open Mobile Platform.

[Code of conduct](CODE_OF_CONDUCT.md) is a current set of rules
of the Open Mobile Platform which informs you how we expect
the members of the community will interact while contributing and communicating.

For information about contributors see [AUTHORS](AUTHORS.md).

## Project Structure

The project has a common structure
of an application based on C++ and QML for Aurora OS.

* **[ru.auroraos.OfficeViewer.pro](application/ru.auroraos.OfficeViewer.pro)** file
  describes the subdirs project that contains two two subprojects where the first is responsible
  for building the libreoffice, and the second describes the structure of the application for
  the qmake build system.
* **[icons](application/icons)** directory contains application icons for different screen resolutions.
* **[qml](application/qml)** directory contains the QML source code and the UI resources.
  * **[cover](application/qml/cover)** directory contains the application cover implementations.
  * **[icons](application/qml/icons)** directory contains the custom UI icons.
  * **[pages](application/qml/pages)** directory contains the application pages.
  * **[DocumentConverter.qml](application/qml/OfficeViewer.qml)** file
    provides the application window implementation.
* **[rpm](rpm)** directory contains the rpm-package build settings.
  **[ru.auroraos.OfficeViewer.spec](rpm/ru.auroraos.OfficeViewer.spec)** file is used by rpmbuild tool.
* **[src](application/src)** directory contains the C++ source code.
  * **[main.cpp](application/src/main.cpp)** file is the application entry point.
* **[translations](application/translations)** directory contains the UI translation files.
* **[ru.auroraos.OfficeViewer.desktop](application/ru.auroraos.OfficeViewer.desktop)** file
  defines the display and parameters for launching the application.
* **[libreoffice](upstream)** directory contains source code LibreOffice (git submodule)
* **[tarballs](tarballs)** directory of dependencies in the form of archives necessary for the build LibreOffice.

## Building

**The application cannot be built with Qt Creator IDE.**
To build the application use the next steps:

* Open a terminal or command prompt.
* Navigate to the directory that contains your Git repository.
* Execute the command `git lfs pull` to download any files tracked by LFS.
* Execute the command `git submodule update --init` to update and initialize any submodules in the repository.
* Set the target `sfdk config target=AuroraOS-4.0.2.249-base-armv7hl`.
* Execute the command `sfdk build-init` to initialize the build enviropment.
* Execute the command `sfdk prepare` to apply the patches needed for the build.
* Execute the command `sfdk build` to start building the package.
* Execute the command `sfdk device list` to show the avaliable devices to deploy the result.
* Execute the command `sfdk config device="INOI P4903 (ARM)"` to set a device to deploy. The INOI P4903 (ARM) is an example of the target device.
* Execute the command to sign the rpm-package:
```
sfdk engine exec rpmsign-external sign  \
    --key absolute/path/to/key/file.pem \
    --cert absolute/path/to/cert/file.pem \
      absolute/path/to/rpm/package.rpm
```

The target rpm-package is in the RPMS directory of the project.
* Execute the command `sfdk deploy --sdk --silent` to deploy the application.

Note: To execute the steps "git lfs pull" and "git submodule update --init", you will need to have Git Large File Storage (LFS) and Git Submodule plugins installed on your system.

## Package signature

You can read about package signing in [package_signing](https://community.omprussia.ru/documentation/software_development/guides/package_signing.html)

