/*******************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
** This file is part of the OfficeViewer project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/


#pragma once

#include <QtCore/QDateTime>
#include <QtCore/QObject>
#include <QtCore/QUrl>

class FileInfo : public QObject
{
    Q_OBJECT
    Q_PROPERTY(QString source READ source WRITE setSource NOTIFY sourceChanged)
    Q_PROPERTY(QString fileName READ fileName NOTIFY sourceChanged)
    Q_PROPERTY(QString baseName READ baseName NOTIFY sourceChanged)
    Q_PROPERTY(QUrl fileUrl READ fileUrl NOTIFY sourceChanged)
    Q_PROPERTY(QString filePath READ filePath NOTIFY sourceChanged)
    Q_PROPERTY(qint64 fileSize READ fileSize NOTIFY sourceChanged)
    Q_PROPERTY(QString mimeType READ mimeType NOTIFY sourceChanged)
    Q_PROPERTY(QString mimeTypeComment READ mimeTypeComment NOTIFY sourceChanged)
    Q_PROPERTY(QDateTime modifiedDate READ modifiedDate NOTIFY sourceChanged)
    Q_PROPERTY(QString path READ path NOTIFY sourceChanged)

public:
    explicit FileInfo(QObject *parent = 0);
    ~FileInfo();

    QString source() const;
    QString fileName() const;
    QString baseName() const;
    QUrl fileUrl() const;
    QString filePath() const;
    qint64 fileSize() const;
    QString mimeType() const;
    QString mimeTypeComment() const;
    QDateTime modifiedDate() const;
    QString path() const;

public Q_SLOTS:
    void setSource(const QString &source);

Q_SIGNALS:
    void sourceChanged();

private:
    class Private;
    Private *const d;
};
