/*******************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
** This file is part of the OfficeViewer project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/


import QtQuick 2.2
import Sailfish.Silica 1.0

Item {
    id: root

    property var popupMenu
    property alias url: linkTarget.text
    readonly property int verticalPadding: 3 * Theme.paddingMedium

    signal closeMenu

    height: content.height + verticalPadding * 2

    Column {
        id: content

        width: parent.width
        spacing: Theme.paddingLarge
        y: verticalPadding

        InfoLabel {
            id: linkTarget

            font.pixelSize: Theme.fontSizeMedium
            wrapMode: Text.Wrap
            elide: Text.ElideRight
            maximumLineCount: 5
            color: Theme.highlightColor
            opacity: Theme.opacityHigh
        }

        Column {
            width: parent.width

            OverlayListItem {
                onClicked: {
                    closeMenu()
                    Qt.openUrlExternally(root.url)
                }
                text: (root.url.indexOf("http:") === 0
                       || root.url.indexOf("https:") === 0)
                      //% "Open in browser"
                      ? qsTrId("docviewer-me-link_open_browser")
                        //% "Open in external application"
                      : qsTrId("docviewer-me-link_open_external")
                horizontalAlignmentText: Text.AlignHCenter
            }
            OverlayListItem {
                onClicked: {
                    closeMenu()
                    Clipboard.text = root.url
                    //% "Сopied"
                    Notices.show(qsTrId("docviewer-me-copied_link"))
                }
                //% "Copy to clipboard"
                text: qsTrId("docviewer-me-copy_link")
                horizontalAlignmentText: Text.AlignHCenter
            }
            OverlayListItem {
                onClicked: closeMenu()
                //% "Cancel"
                text: qsTrId("docviewer-me-cancel")
                horizontalAlignmentText: Text.AlignHCenter
            }
        }
    }
}
