/*******************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
** This file is part of the OfficeViewer project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/


import QtQuick 2.6
import Sailfish.Silica 1.0

BackgroundItem {
    id: root

    property alias text: label.text
    property alias iconSource: icon.source
    property alias checked: toggle.checked
    property alias horizontalAlignmentText: label.horizontalAlignment
    property bool checkable
    property int horizontalOffset
    property int iconWidth

    width: parent.width

    Item {
        id: iconContainer

        width: iconWidth
        height: parent.height
        x: Theme.paddingMedium

        Icon {
            id: icon

            anchors {
                centerIn: parent
                horizontalCenterOffset: horizontalOffset
            }
            highlighted: root.highlighted
            color: Theme.primaryColor
            opacity: root.enabled ? 1.0 : Theme.opacityLow
        }
    }
    Label {
        id: label

        anchors {
            left: iconContainer.right
            leftMargin: Theme.paddingMedium
            right: parent.right
            rightMargin: toggle.visible ? toggle.width + Theme.paddingMedium : Theme.horizontalPageMargin
            verticalCenter: parent.verticalCenter
        }
        color: root.highlighted ? Theme.highlightColor : Theme.primaryColor
        opacity: root.enabled ? 1.0 : Theme.opacityLow
        truncationMode: TruncationMode.Fade

        Behavior on opacity { FadeAnimation {} }
    }
    Switch {
        id: toggle
        anchors {
            right: parent.right
            verticalCenter: parent.verticalCenter
        }

        visible: checkable
        onClicked: root.clicked(mouse)
    }
}
