/*******************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
** This file is part of the OfficeViewer project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/


#include "documentprovider.h"

#include <QFileInfo>
#include <QUrl>

BaseDocumentProvider::BaseDocumentProvider(QObject *parent)
    : QObject(parent)
    , m_isLoaded(false)
    , m_isInitialized(false)
    , m_processing(false)
    , m_pageCount(0)
    , m_loadProgress(0)
    , m_error(NoError)
    , m_documentType(Other)
{}

QString BaseDocumentProvider::path() const
{
    return m_path;
}

void BaseDocumentProvider::setPath(const QString &newPath)
{
    if (m_path != newPath) {
        m_path = newPath;
        emit pathChanged();

        QUrl url(m_path);
        setFileName(url.fileName());
        load(url);
    }
}

QString BaseDocumentProvider::fileName() const
{
    return m_fileName;
}

void BaseDocumentProvider::setFileName(const QString &newFileName)
{
    if (m_fileName != newFileName) {
        m_fileName = newFileName;
        emit fileNameChanged();
    }
}

bool BaseDocumentProvider::loaded() const
{
    return m_isLoaded;
}

void BaseDocumentProvider::setLoaded(bool newLoaded)
{
    if (m_isLoaded != newLoaded) {
        m_isLoaded = newLoaded;
        emit loadedChanged();
    }
}

bool BaseDocumentProvider::initialized() const
{
    return m_isInitialized;
}

void BaseDocumentProvider::setInitialized(bool newInitialized)
{
    if (m_isInitialized != newInitialized) {
        m_isInitialized = newInitialized;
        emit initializedChanged();
    }
}

int BaseDocumentProvider::loadProgress() const
{
    return m_loadProgress;
}

void BaseDocumentProvider::setLoadProgress(int newLoadProgress)
{
    if (m_loadProgress != newLoadProgress) {
        m_loadProgress = newLoadProgress;
        emit loadProgressChanged();
    }
}

int BaseDocumentProvider::error() const
{
    return m_error;
}

void BaseDocumentProvider::setError(const int error)
{
    if (m_error == error)
        return;

    m_error = error;
    emit errorChanged(m_error);
}

BaseDocumentProvider::DocumentType BaseDocumentProvider::documentType() const
{
    return m_documentType;
}

void BaseDocumentProvider::setDocumentType(BaseDocumentProvider::DocumentType type)
{
    if (m_documentType != type) {
        m_documentType = type;
        emit documentTypeChanged();
    }
}

bool BaseDocumentProvider::processing() const
{
    return m_processing;
}

void BaseDocumentProvider::setProcessing(bool processing)
{
    if (m_processing == processing)
        return;

    m_processing = processing;
    emit processingChanged(m_processing);
}

QString BaseDocumentProvider::selectedHyperlink() const
{
    return m_selectedHyperlink;
}

void BaseDocumentProvider::setSelectedHyperlink(const QString &selectedHyperlink)
{
    m_selectedHyperlink = selectedHyperlink;
    emit selectedHyperlinkChanged(m_selectedHyperlink);
}

int BaseDocumentProvider::pageCount() const
{
    return m_pageCount;
}

void BaseDocumentProvider::setPageCount(int pageCount)
{
    if (m_pageCount != pageCount) {
        m_pageCount = pageCount;
        emit pageCountChanged();
    }
}

QList<QString> BaseDocumentProvider::pageNames() const
{
    return m_pageNames;
}

void BaseDocumentProvider::setPageNames(const QList<QString> &pageNames)
{
    if (m_pageNames != pageNames) {
        m_pageNames = pageNames;
        emit pageNamesChanged();
    }
}
