/*******************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
** This file is part of the OfficeViewer project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/



#ifndef DOCUMENTPROVIDER_H
#define DOCUMENTPROVIDER_H

#include <QObject>
#include <QUrl>
#include <QtGui/QImage>

class DocumentProvider : public QObject
{
    Q_OBJECT
    Q_PROPERTY(int count READ count NOTIFY countChanged)
    Q_PROPERTY(QUrl icon READ icon NOTIFY iconChanged)
    Q_PROPERTY(QUrl thumbnail READ thumbnail NOTIFY thumbnailChanged)
    Q_PROPERTY(QString title READ title NOTIFY titleChanged)
    Q_PROPERTY(QObject *model READ model NOTIFY modelChanged)
    Q_PROPERTY(bool ready READ isReady NOTIFY readyChanged)
    Q_PROPERTY(QUrl page READ page WRITE setPage NOTIFY pageChanged)
    Q_PROPERTY(QString setupPageUrl READ setupPageUrl NOTIFY titleChanged)
    Q_PROPERTY(bool needsSetup READ needsSetup NOTIFY needsSetupChanged)

public:
    DocumentProvider(QObject *parent = 0);
    virtual ~DocumentProvider();

    virtual int count() const = 0;
    virtual QUrl icon() const = 0;
    virtual QString title() const = 0;
    virtual QString description() const = 0;
    virtual QObject *model() const = 0;
    virtual QUrl thumbnail() const = 0;
    virtual bool isReady() const = 0;
    // Reimplement this and return the name of a QML file containing the account setup
    // for this provider, if applicable. Otherwise a no-setup provider will be assumed.
    virtual QString setupPageUrl() const;
    virtual bool needsSetup() const;

    QUrl page() const;
    void setPage(const QUrl &url);

    Q_INVOKABLE virtual void deleteFile(const QUrl &file);

signals:
    void countChanged();
    void iconChanged();
    void thumbnailChanged();
    void pageChanged();
    void titleChanged();
    void modelChanged();
    void readyChanged();
    void needsSetupChanged();
    void fileDeleted(const QString &filePath);

private:
    class Private;
    Private *d;
};

Q_DECLARE_INTERFACE(DocumentProvider, "DocumentProviderInterface/1.0")

#endif // DOCUMENTPROVIDER_H
