################################################################################
##
## SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
## SPDX-License-Identifier: BSD-3-Clause
## This file is part of the OfficeViewer project.
##
## Redistribution and use in source and binary forms,
## with or without modification, are permitted provided
## that the following conditions are met:
##
## * Redistributions of source code must retain the above copyright notice,
##   this list of conditions and the following disclaimer.
## * Redistributions in binary form must reproduce the above copyright notice,
##   this list of conditions and the following disclaimer
##   in the documentation and/or other materials provided with the distribution.
## * Neither the name of the copyright holder nor the names of its contributors
##   may be used to endorse or promote products derived from this software
##   without specific prior written permission.
##
## THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
## AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
## THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
## FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
## IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
## FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
## OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
## PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
## LOSS OF USE, DATA, OR PROFITS;
## OR BUSINESS INTERRUPTION)
## HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
## WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
## (INCLUDING NEGLIGENCE OR OTHERWISE)
## ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
## EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
##
################################################################################


TEMPLATE = lib
QT += qml quick 
QT -= gui
CONFIG += qt plugin hide_symbols c++17 link_pkgconfig

INCLUDEPATH += $$PWD/../documentprovider/base/src
LIBS += -L../documentprovider/base -ldocumentprovider

TARGET = $$qtLibraryTarget(docviewerplugin)
target.path = $$[QT_INSTALL_QML]/ru/omp/docviewer

qml.files = qmldir *.qml utils.js components
qml.path = $$[QT_INSTALL_QML]/ru/omp/docviewer

INSTALLS = target qml

VIEW_HEADERS += \
    src/bitmaploadworker.h \
    src/documentmapper.h \
    src/pagecontainer.h \
    src/pagetile.h \
    src/multipagetile.h \
    src/basedocitem.h \
    src/docitemannotation.h \
    src/docitemcomment.h \
    src/docitemsearchhighlight.h \
    src/docitemcellselected.h \
    src/docview.h \
    src/docviewtypes.h \
    src/fileinfo.h \
    src/backgroundpage.h

VIEW_SOURCES += \
    src/bitmaploadworker.cpp \
    src/documentmapper.cpp \
    src/pagecontainer.cpp \
    src/pagetile.cpp \
    src/multipagetile.cpp \
    src/basedocitem.cpp \
    src/docitemannotation.cpp \
    src/docitemcomment.cpp \
    src/docitemsearchhighlight.cpp \
    src/docitemcellselected.cpp \
    src/docview.cpp \
    src/fileinfo.cpp \
    src/backgroundpage.cpp

HEADERS += \
    $$VIEW_HEADERS \
    src/bookmarksmodel.h

SOURCES += \
    $$VIEW_SOURCES \
    src/bookmarksmodel.cpp \
    src/plugin.cpp

INCLUDEPATH += \
    src \

DISTFILES += *.qml utils.js components/*.qml

DEFINES += \
    PRELOAD_PAGES_COUNT=10 \
    HIGHLIGHT_OPACITY_ANNOT_ON=178 \
    HIGHLIGHT_OPACITY_ANNOT_OFF=42 \
    HIGHLIGHT_OPACITY_NOTE_ON=198 \
    HIGHLIGHT_OPACITY_NOTE_OFF=100

QMAKE_CXXFLAGS += -std=c++17
