/*******************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
** This file is part of the OfficeViewer project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/


import QtQuick 2.4
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0

Rectangle {
    property real zoom: 1.0

    function show() {
        opacity = 1.0
        timer.start()
    }

    opacity: 0.0
    visible: opacity
    color: Qt.tint(Theme.darkPrimaryColor, Theme.rgba(Theme.lightPrimaryColor, Theme.opacityFaint))
    radius: Theme.paddingSmall
    height: label.height + Theme.paddingLarge
    width: label.width + Theme.paddingLarge

    onZoomChanged: show()

    Behavior on opacity { FadeAnimation { } }

    Label {
        id: label
        anchors.centerIn: parent
        text: ("%1%").arg(Math.round(zoom * 100))
        font.pixelSize: Theme.fontSizeSmall
        font.family: "Courier"
        color: Theme.lightPrimaryColor
    }

    Timer {
        id: timer
        interval: 2500
        onTriggered: opacity = 0.0
    }
}
