/*******************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
** This file is part of the OfficeViewer project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/


import QtQuick 2.2
import Sailfish.Silica 1.0

Item {
    id: root

    property int horizontalOffset
    property var desktopBookmarkWriter
    property bool enabledSearch: true
    property bool enabledExportPdf: true
    readonly property int verticalPadding: 3 * Theme.paddingSmall
    readonly property int iconWidth: Theme.iconSizeMedium + Theme.paddingLarge

    signal searchClicked
    signal shareClicked
    signal infoClicked
    signal exportToPdf
    signal printClicked
    signal saveAsClicked

    height: content.height + verticalPadding * 2

    Column {
        id: content
        width: parent.width
        spacing: Theme.paddingLarge
        y: verticalPadding

        Column {
            width: parent.width

            OverlayListItem {
                onClicked: {
                    popupMenu.closed()
                    root.searchClicked()
                }
                enabled: root.enabledSearch
                height: Theme.itemSizeSmall
                iconWidth: root.iconWidth
                iconSource: "image://theme/icon-m-search"
                //% "Search by document"
                text: qsTrId("docviewer-la-search_by_doc")
            }

            OverlayListItem {
                onClicked: {
                    popupMenu.closed()
                    root.shareClicked()
                }
                height: Theme.itemSizeSmall
                iconWidth: root.iconWidth
                iconSource: "image://theme/icon-m-share"
                //% "Share"
                text: qsTrId("docviewer-la-share")
            }

            OverlayListItem {
                onClicked: {
                    popupMenu.closed()
                    root.exportToPdf()
                }
                enabled: enabledExportPdf
                height: Theme.itemSizeSmall
                iconWidth: root.iconWidth
                iconSource: "image://theme/icon-m-file-download-as-pdf"
                //% "Export to PDF"
                text: qsTrId("docviewer-la-export_to_pdf")
            }

            OverlayListItem {
                onClicked: {
                    popupMenu.closed()
                    root.printClicked()
                }
                enabled: enabledExportPdf
                height: Theme.itemSizeSmall
                iconWidth: root.iconWidth
                iconSource: "image://theme/icon-m-print"
                //% "Print"
                text: qsTrId("docviewer-la-print")
            }

            OverlayListItem {
                onClicked: {
                    popupMenu.closed()
                    root.saveAsClicked()
                }
                enabled: enabledExportPdf
                height: Theme.itemSizeSmall
                iconWidth: root.iconWidth
                iconSource: "image://theme/icon-m-save"
                //% "Save as"
                text: qsTrId("docviewer-la-save_as")
            }

            OverlayListItem {
                onClicked: {
                    popupMenu.closed()
                    root.infoClicked()
                }
                height: Theme.itemSizeSmall
                iconWidth: root.iconWidth
                iconSource: "image://theme/icon-m-about"
                //% "Document Information"
                text: qsTrId("docviewer-la-doc_info")
            }
        }
    }
}
