/*******************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
** This file is part of the OfficeViewer project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/


#include <QMetaType>

#include "basedocument.h"

BaseDocument::BaseDocument(QObject *parent)
    : QObject(parent)
    , m_loadingProgress(0)
    , m_pageIndex(-1)
    , m_mode(Mode::ModeView)
{
    qRegisterMetaType<PageLoadStatus>();
}

BaseDocument::~BaseDocument() = default;

BaseDocument::DocumentStatus BaseDocument::status() const
{
    return m_status;
}

QString BaseDocument::path() const
{
    return m_path;
}

bool BaseDocument::processing() const
{
    return m_processing;
}

int BaseDocument::loadingProgress() const
{
    return m_loadingProgress;
}

void BaseDocument::setLoadingProgress(int loadingProgress)
{
    if (m_loadingProgress == loadingProgress)
        return;

    m_loadingProgress = loadingProgress;
    emit loadingProgressChanged(m_loadingProgress);
}

void BaseDocument::setProcessing(bool processing)
{
    if (m_processing == processing)
        return;

    m_processing = processing;
    emit processingChanged(m_processing);
}

int BaseDocument::pageIndex() const
{
    return m_pageIndex;
}

void BaseDocument::setPageIndex(int newPageIndex)
{
    if (m_pageIndex == newPageIndex)
        return;
    m_pageIndex = newPageIndex;
    emit pageIndexChanged(m_pageIndex);
}

BaseDocument::Mode BaseDocument::mode() const
{
    return m_mode;
}

void BaseDocument::setMode(Mode newMode)
{
    if (m_mode == newMode)
        return;
    m_mode = newMode;
    emit modeChanged();
}
