/*******************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
** This file is part of the OfficeViewer project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/



#ifndef TRACKERDOCUMENTPROVIDER_H
#define TRACKERDOCUMENTPROVIDER_H

#include "documentprovider.h"

#include <QtCore/QFileInfo>
#include <QtCore/QHash>
#include <QtCore/QRunnable>
#include <QtQml/QQmlParserStatus>
#include <QMimeDatabase>

class DocumentListModel;
class TrackerDocumentProvider : public DocumentProvider, public QQmlParserStatus
{
    Q_OBJECT
    Q_INTERFACES(DocumentProvider QQmlParserStatus)

public:
    enum DocumentType
    {
        TextDocumentType,
        SpreadsheetType,
        PresentationType
    };
    TrackerDocumentProvider(QObject *parent = 0);
    ~TrackerDocumentProvider();
    int count() const override;
    QUrl icon() const override;
    QString title() const override;
    QString description() const override;
    QObject *model() const override;
    QUrl thumbnail() const override;
    bool isReady() const override;

    void classBegin() override;
    void componentComplete() override;

    void deleteFile(const QUrl &file) override;

    Q_INVOKABLE bool isPdf(const QString &url) const;

public Q_SLOTS:
    void startSearch();
    void stopSearch();

private Q_SLOTS:
    void searchFinished();
    void trackerGraphChanged(const QString &graphName);

private:
    class Private;
    Private *d;
    QString getMimeType( QString filePath );
    int getFileSize( QString filePath );
};

#endif // TRACKERDOCUMENTPROVIDER_H
