/*******************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
** This file is part of the OfficeViewer project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/



#include "filtermodel.h"

#include "documentlistmodel.h"

FilterModel::FilterModel(QObject *parent)
    : QSortFilterProxyModel(parent)
{
    this->setFilterRole(DocumentListModel::Roles::FileNameRole);
    setSortParameter(SortParameter::Date);
    setSortCaseSensitivity(Qt::CaseInsensitive);
}

FilterModel::~FilterModel() {}

void FilterModel::setSourceModel(DocumentListModel *model)
{
    QSortFilterProxyModel::setSourceModel(static_cast<QAbstractItemModel *>(model));
}

int FilterModel::sortParameter() const
{
    return m_sortParameter;
}

void FilterModel::setSortParameter(int sortParameter)
{
    if (m_sortParameter == sortParameter) {
        return;
    }

    m_sortParameter = sortParameter;
    Qt::SortOrder order = Qt::AscendingOrder;

    switch (m_sortParameter) {
    case Name:
        setSortRole(DocumentListModel::Roles::FileNameRole);
        break;
    case Type:
        setSortRole(DocumentListModel::Roles::FileTypeAndNameRole);
        break;
    case Date:
        setSortRole(DocumentListModel::Roles::FileReadRole);
        order = Qt::DescendingOrder;
        break;
    default:
        break;
    }

    emit sortParameterChanged();

    sort(0, order);
}

DocumentListModel *FilterModel::sourceModel() const
{
    return static_cast<DocumentListModel *>(QSortFilterProxyModel::sourceModel());
}
