/*******************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
** This file is part of the OfficeViewer project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/




#ifndef DOCUMENTLISTMODEL_H
#define DOCUMENTLISTMODEL_H

#include <QAbstractListModel>
#include <qdatetime.h>

class DocumentListModelPrivate;

class DocumentListModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(int rowCount READ rowCount NOTIFY rowCountChanged)

public:
    enum DocumentClass
    {
        UnknownDocument,
        TextDocument,
        PlainTextDocument,
        SpreadSheetDocument,
        PresentationDocument,
        PDFDocument
    };
    Q_ENUMS(DocumentClass)

    enum Roles
    {
        FileNameRole = Qt::UserRole + 1,
        FilePathRole,
        FileTypeRole,
        FileSizeRole,
        FileReadRole,
        FileMimeTypeRole,
        FileDocumentClass,
        FileTypeAndNameRole
    };

    DocumentListModel(QObject *parent = 0);
    ~DocumentListModel();

    DocumentListModel(const DocumentListModel &) = delete;
    DocumentListModel &operator=(const DocumentListModel &) = delete;

    virtual QVariant data(const QModelIndex &index, int role) const;
    virtual int rowCount(const QModelIndex &parent = QModelIndex{}) const;
    virtual QHash<int, QByteArray> roleNames() const;

    void setAllItemsDirty(bool status);
    void addItem(QString name, QString path, QString type, int size, QDateTime lastRead, QString mimeType);
    void removeItemsDirty();
    void removeAt(int index);
    void clear();

    Q_INVOKABLE int mimeTypeToDocumentClass(QString mimeType) const;
    Q_INVOKABLE static QVariantMap getFileInfo(const QString &filePath);

signals:
    void fileDeleted(const QString &filePath);
    void rowCountChanged();

private:
    class Private;
    const QScopedPointer<Private> d;
};

#endif // DOCUMENTLISTMODEL_H
