/*******************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
** This file is part of the OfficeViewer project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/


import QtQuick 2.0
import Sailfish.Silica 1.0
import Aurora.Office.Files 1.0
import "pages"
import "cover"

ApplicationWindow
{
    id: applicationWindow

    property DocumentListModel fileListModel: trackerProvider.model
    property Item documentItem
    property Page mainPage

    property var docView: null

    signal searchRequest()

    allowedOrientations: Orientation.All
    _defaultPageOrientations: Orientation.All
    initialPage: Component {
        FileListPage {
            id: fileListPage

            Component.onCompleted: {
                applicationWindow.mainPage = fileListPage
            }
            model: trackerProvider.model
            provider: trackerProvider
        }
    }
    cover: Component {
        CoverPage {}
    }

    TrackerDocumentProvider {
        id: trackerProvider
    }

    function mimeToIcon(fileMimeType) {
        var iconType = "other"
        switch (fileMimeType) {
        case "text/x-vnote":
            iconType = "note"
            break
        case "application/pdf":
            iconType = "pdf"
            break
        case "application/vnd.oasis.opendocument.spreadsheet":
        case "application/x-kspread":
        case "application/vnd.ms-excel":
        case "text/csv":
        case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet":
        case "application/vnd.openxmlformats-officedocument.spreadsheetml.template":
            iconType = "spreadsheet"
            break
        case "application/vnd.oasis.opendocument.presentation":
        case "application/vnd.oasis.opendocument.presentation-template":
        case "application/x-kpresenter":
        case "application/vnd.ms-powerpoint":
        case "application/vnd.openxmlformats-officedocument.presentationml.presentation":
        case "application/vnd.openxmlformats-officedocument.presentationml.template":
            iconType = "presentation"
            break
        case "text/plain":
        case "application/vnd.oasis.opendocument.text-master":
        case "application/vnd.oasis.opendocument.text":
        case "application/vnd.oasis.opendocument.text-template":
        case "application/msword":
        case "application/rtf":
        case "application/x-mswrite":
        case "application/vnd.openxmlformats-officedocument.wordprocessing":
        case "application/vnd.openxmlformats-officedocument.wordprocessingml.document":
        case "application/vnd.openxmlformats-officedocument.wordprocessingml.template":
        case "application/vnd.ms-works":
            iconType = "formatted"
            break
        }
        return "image://theme/icon-m-file-" + iconType
    }

    Connections {
        target: pageStack
        onCurrentPageChanged: {
            if (pageStack.currentPage !== null) {
                applicationWindow.documentItem = pageStack.currentPage
            }
        }
        onDepthChanged: {
            if (pageStack.depth <= 1) {
                applicationWindow.docView = null
            }
        }
        ignoreUnknownSignals: true
    }
}

