/*******************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
** This file is part of the OfficeViewer project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/


#pragma once

#include <QQuickItem>
#include <QImage>
#include <QPointer>

class BasePage;
class QTimer;
class QSGTexture;
class QPropertyAnimation;
class BitmapLoaderWorker;
class PageTile : public QQuickItem
{
    Q_OBJECT

    Q_PROPERTY(bool renderable READ renderable WRITE setRenderable NOTIFY renderableChanged)

public:
    explicit PageTile(QQuickItem *parent = nullptr);
     ~PageTile() override;

    QSGNode *updatePaintNode(QSGNode *oldNode, UpdatePaintNodeData *) override;
    void geometryChanged(const QRectF &newGeometry, const QRectF &oldGeometry) override;

    void setPageSource(QSharedPointer<BasePage> pageSource);
    bool renderable() const;
    bool isBitmap() const;
    void setDebugText(const QString &newDebugText);

public slots:
    void setImageScale(qreal imageScale);
    void render(bool force = false);
    void setRenderable(bool renderable);

signals:
    void bitmapError();
    void partReady();
    void animationEnded();
    void renderableChanged(bool renderable);
    void stopRender();

private slots:
    void _loadBitmap();
    void _clearImage();
    void _debugDraw(QImage *image);
    void _debugDraw(QImage *image, QColor color);
    void _updateDebugStatus();

private:
    QImage m_pagePart;
    QSharedPointer<BasePage> m_pageSource;
    bool m_needUpdateImage;
    bool m_needClearImage;
    bool m_renderInProcess;
    bool m_renderable;
    bool m_forceRender;
    QTimer *m_timer;
    QTimer *m_timerClear;
    qreal m_imageScale;
    QPropertyAnimation *m_animation;
    QString m_debugText;
    bool m_debugCancel;
    bool m_debugError;
    QPointer<BitmapLoaderWorker> m_loader;
};
