################################################################################
##
## SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
## SPDX-License-Identifier: BSD-3-Clause
## This file is part of the OfficeViewer project.
##
## Redistribution and use in source and binary forms,
## with or without modification, are permitted provided
## that the following conditions are met:
##
## * Redistributions of source code must retain the above copyright notice,
##   this list of conditions and the following disclaimer.
## * Redistributions in binary form must reproduce the above copyright notice,
##   this list of conditions and the following disclaimer
##   in the documentation and/or other materials provided with the distribution.
## * Neither the name of the copyright holder nor the names of its contributors
##   may be used to endorse or promote products derived from this software
##   without specific prior written permission.
##
## THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
## AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
## THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
## FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
## IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
## FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
## OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
## PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
## LOSS OF USE, DATA, OR PROFITS;
## OR BUSINESS INTERRUPTION)
## HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
## WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
## (INCLUDING NEGLIGENCE OR OTHERWISE)
## ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
## EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
##
################################################################################


TEMPLATE = lib
TARGET  = libreofficeplugin
TARGET = $$qtLibraryTarget($$TARGET)

TARGETPATH = $$[QT_INSTALL_QML]/ru/omp/documentprovider/libreoffice

QT += qml quick concurrent
QT -= gui
CONFIG += plugin C++17
QMAKE_CXXFLAGS += -O3 -std=c++17

INCLUDEPATH += \
    $$PWD/../../application \
    $$PWD/../base/src \
    $$PWD/../libreoffice-worker

LIBS += -L../base -ldocumentprovider

HEADERS += \
    src/lodocumentprovider.h \
    src/lopageprovider.h \
    src/lopage.h \
    src/lodocument.h \
    src/pagepreloader.h \
    src/loevent.h

SOURCES += \
    src/plugin.cpp \
    src/lodocumentprovider.cpp \
    src/lopageprovider.cpp \
    src/lopage.cpp \
    src/lodocument.cpp \
    src/pagepreloader.cpp \
    src/loevent.cpp

DEFINES += WORKER_PATH=\\\"/usr/libexec/libreoffice-worker\\\"

DISTFILES += \
    qml/qmldir

target.path = $$TARGETPATH

components.files = $${DISTFILES}
components.path = $$TARGETPATH

INSTALLS += target components
