#!/bin/sh
set -e

echo "Start building..."
~/AuroraOS/bin/sfdk config target=AuroraOS-4.0.2.249-base-armv7hl
~/AuroraOS/bin/sfdk build

echo "Building result is $?"

echo "Building is finished"

echo "Set the INOI P4903 (ARM) device to deploy"
~/AuroraOS/bin/sfdk config device="INOI P4903 (ARM)"

echo "Signing..."

~/AuroraOS/bin/sfdk engine exec rpmsign-external sign  \
	--key /home/vladislav/projects/cert/packages-key.pem \
	--cert /home/vladislav/projects/cert/fruct/packages-cert-fruct.pem \
	  /home/vladislav/projects/DocumentConverter/RPMS/ru.auroraos.OfficeViewer-0.0.1-1.armv7hl.rpm


echo "Deploying..."
~/AuroraOS/bin/sfdk deploy --sdk --silent
# sfdk deploy --sdk  --silent --all "ru.auroraos.OfficeViewer" && sfdk device exec /usr/bin/ru.auroraos.OfficeViewer
# ~/AuroraOS/bin/sfdk deploy --sdk  --silent --all "ru.auroraos.OfficeViewer"

echo "Deploying result is $?"

echo "Done"

echo "Start the application..."
~/AuroraOS/bin/sfdk device exec /usr/bin/ru.auroraos.OfficeViewer
