#ifndef LICENSESTATUS_H
#define LICENSESTATUS_H

#include <QObject>

class LicenseStatus : public QObject
{
    Q_OBJECT

    Q_PROPERTY(bool isAccepted READ isAccepted NOTIFY isAcceptedChanged)

public:
    explicit LicenseStatus(QObject *parent = nullptr);

    bool isAccepted() const;

    Q_INVOKABLE void accept();
    Q_INVOKABLE QString textLicense(const QString &localeName) const;

signals:
    void isAcceptedChanged();

private:
    bool m_isAccepted;
};

#endif // LICENSESTATUS_H
