/*******************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
** This file is part of the OfficeViewer project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/



import QtQuick 2.4
import Sailfish.Silica 1.0
import ru.omp.documentprovider.libreoffice 1.0

CoverBackground {
    id: root

    property bool actionsEnable: false

    property bool documentViewOpenedOnce: false

    readonly property bool isPortrait: root.orientation === Cover.Vertical

    readonly property bool privateMode: false //! TODO

    readonly property alias __cover: root

    Connections {
        target: applicationWindow

        onVisibleChanged: {
            coverPrivate.updateDocumentViewOpenedOnce()
        }

        onDocViewChanged: {
            if (!applicationWindow.docView) {
                root.documentViewOpenedOnce = false
            }
        }
    }

    Connections {
        target: {
            if (applicationWindow.docView) {
                return applicationWindow.docView.documentProvider
            }

            return null
        }

        onStatusChanged: {
            coverPrivate.updateDocumentViewOpenedOnce()
        }
    }

    Loader {
        id: coverContentLoader

        anchors {
            fill: parent
            leftMargin: Theme.paddingCover
            rightMargin: Theme.paddingCover
        }

        objectName: "coverContentLoader"

        sourceComponent: {
            if (applicationWindow.docView
                    && !root.privateMode
                    && root.documentViewOpenedOnce) {
                return documentItemComponent
            }

            if (fileListModel.rowCount > 0) {
                return documentsViewComponent
            }

            return noDocumentsItemComponent
        }

        Component {
            id: noDocumentsItemComponent

            CoverNoDocumentsItem {}
        }

        Component {
            id: documentsViewComponent

            CoverDocumentsView {}
        }

        Component {
            id: documentItemComponent

            CoverDocumentItem {}
        }
    }

    CoverActionList {
        enabled: root.actionsEnable

        CoverAction {
            iconSource: "image://theme/icon-cover-search"
            onTriggered: {
                applicationWindow.searchRequest()
            }
        }
    }

    QtObject {
        id: coverPrivate

        function updateDocumentViewOpenedOnce() {
            if (!applicationWindow.visible
                    || root.documentViewOpenedOnce
                    || !applicationWindow.docView) {
                return
            }

            root.documentViewOpenedOnce = applicationWindow.docView.documentProvider.status === LoDocument.Ready
        }
    }
}
