/*******************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
** This file is part of the OfficeViewer project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/



import QtQuick 2.0
import Sailfish.Silica 1.0

Item {
    id: root

    Icon {
        id: icon

        source: "image://theme/icon-splus-cover-docs"
    }

    Label {
        id: welcomeTitle

        anchors {
            left: parent.left
            right: parent.right
            top: icon.bottom
            topMargin: Theme.paddingMedium
        }

        //% "Welcome to Documents!"
        text: qsTrId("docviewer-la-welcome_do_documents")
        wrapMode: Label.WordWrap
        maximumLineCount: 2
        font.weight: Font.Medium
        truncationMode: TruncationMode.Fade
        color: Theme.primaryColor
        font.pixelSize: Theme.fontSizeExtraSmall
    }

    Label {
        id: noDocumentsSubTitle

        anchors {
            left: parent.left
            right: parent.right
            top: welcomeTitle.bottom
            topMargin: __cover.isPortrait
                       ? Theme.paddingMedium
                       : Theme.paddingSmall
        }


        //% "There is no documents on device yet"
        text: qsTrId("docviewer-la-device_no_documents")
        wrapMode: Label.WordWrap
        maximumLineCount: 2
        truncationMode: TruncationMode.Fade
        color: Theme.secondaryColor
        font.pixelSize: Theme.fontSizeTiny
    }
}
