################################################################################
##
## SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
## SPDX-License-Identifier: BSD-3-Clause
## This file is part of the OfficeViewer project.
##
## Redistribution and use in source and binary forms,
## with or without modification, are permitted provided
## that the following conditions are met:
##
## * Redistributions of source code must retain the above copyright notice,
##   this list of conditions and the following disclaimer.
## * Redistributions in binary form must reproduce the above copyright notice,
##   this list of conditions and the following disclaimer
##   in the documentation and/or other materials provided with the distribution.
## * Neither the name of the copyright holder nor the names of its contributors
##   may be used to endorse or promote products derived from this software
##   without specific prior written permission.
##
## THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
## AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
## THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
## FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
## IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
## FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
## OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
## PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
## LOSS OF USE, DATA, OR PROFITS;
## OR BUSINESS INTERRUPTION)
## HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
## WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
## (INCLUDING NEGLIGENCE OR OTHERWISE)
## ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
## EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
##
################################################################################

TARGET = ru.auroraos.OfficeViewer

QT     += core dbus

CONFIG += \
    auroraapp

PKGCONFIG += \

SOURCES += \
    src/converter.cpp \
    src/main.cpp \
    src/filtermodel.cpp \
    src/documentlistmodel.cpp \
    src/trackerdocumentprovider.cpp \
    src/documentprovider.cpp

HEADERS += \
    src/converter.h \
    src/filtermodel.h \
    src/documentlistmodel.h \
    src/trackerdocumentprovider.h \
    src/documentprovider.h

INCLUDEPATH += \
    LibreOfficeKit

LIBS += -ldl

DISTFILES += \
    qml/OfficeViewer.qml \
    qml/images/Documents.svg \
    qml/cover/CoverPage.qml \
    qml/cover/CoverFileItem.qml \
    qml/pages/FileListPage.qml \
    qml/pages/SortTypeSelectionPage.qml

AURORAAPP_ICONS = 86x86 108x108 128x128 172x172


OTHER_FILES += \
    licenses/*.txt

CONFIG += auroraapp_i18n

TRANSLATIONS += \
    translations/ru.auroraos.OfficeViewer.ts \
    translations/ru.auroraos.OfficeViewer-ru.ts \

translations.path = /usr/share/$${TARGET}/translations
translations.files = $$TRANSLATIONS

INSTALLS += \
    translations

SUPPORT_MIMETYPES = "$$system(cat $$IN_PWD/ru.auroraos.OfficeViewer.desktop | grep MimeType)"
SUPPORT_MIMETYPES ~= s/MimeType=//
SUPPORT_MIMETYPES ~= s/;$//
SUPPORT_MIMETYPES = $$replace(SUPPORT_MIMETYPES, ";", ",")

DEFINES +=  SUPPORT_MIMETYPES=\\\"$$SUPPORT_MIMETYPES\\\"
