TEMPLATE = lib
QT += qml quick 
QT -= gui
CONFIG += qt plugin hide_symbols c++17 link_pkgconfig

INCLUDEPATH += $$PWD/../documentprovider/base/src
LIBS += -L../documentprovider/base -ldocumentprovider

TARGET = $$qtLibraryTarget(docviewerplugin)
target.path = $$[QT_INSTALL_QML]/ru/omp/docviewer

qml.files = qmldir *.qml utils.js components
qml.path = $$[QT_INSTALL_QML]/ru/omp/docviewer

INSTALLS = target qml

VIEW_HEADERS += \
    src/bitmaploadworker.h \
    src/documentmapper.h \
    src/pagecontainer.h \
    src/pagetile.h \
    src/multipagetile.h \
    src/basedocitem.h \
    src/docitemannotation.h \
    src/docitemcomment.h \
    src/docitemsearchhighlight.h \
    src/docitemcellselected.h \
    src/docview.h \
    src/docviewtypes.h \
    src/fileinfo.h \
    src/backgroundpage.h

VIEW_SOURCES += \
    src/bitmaploadworker.cpp \
    src/documentmapper.cpp \
    src/pagecontainer.cpp \
    src/pagetile.cpp \
    src/multipagetile.cpp \
    src/basedocitem.cpp \
    src/docitemannotation.cpp \
    src/docitemcomment.cpp \
    src/docitemsearchhighlight.cpp \
    src/docitemcellselected.cpp \
    src/docview.cpp \
    src/fileinfo.cpp \
    src/backgroundpage.cpp

HEADERS += \
    $$VIEW_HEADERS \
    src/bookmarksmodel.h

SOURCES += \
    $$VIEW_SOURCES \
    src/bookmarksmodel.cpp \
    src/plugin.cpp

INCLUDEPATH += \
    src \

DISTFILES += *.qml utils.js components/*.qml

DEFINES += \
    PRELOAD_PAGES_COUNT=10 \
    HIGHLIGHT_OPACITY_ANNOT_ON=178 \
    HIGHLIGHT_OPACITY_ANNOT_OFF=42 \
    HIGHLIGHT_OPACITY_NOTE_ON=198 \
    HIGHLIGHT_OPACITY_NOTE_OFF=100

QMAKE_CXXFLAGS += -std=c++17
