/*
 * Copyright (c) 2023 Open Mobile Platform LLC.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
.pragma library

function docviewerType(mimeType) {
    switch (mimeType) {
    case "application/vnd.oasis.opendocument.spreadsheet":
    case "application/x-kspread":
    case "application/vnd.ms-excel":
    case "text/csv":
    case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet":
    case "application/vnd.openxmlformats-officedocument.spreadsheetml.template":
        return "calc"
    case "application/vnd.oasis.opendocument.presentation":
    case "application/vnd.oasis.opendocument.presentation-template":
    case "application/x-kpresenter":
    case "application/vnd.ms-powerpoint":
    case "application/vnd.openxmlformats-officedocument.presentationml.presentation":
    case "application/vnd.openxmlformats-officedocument.presentationml.template":
        return "impress"
    case "application/vnd.oasis.opendocument.text-master":
    case "application/vnd.oasis.opendocument.text":
    case "application/vnd.oasis.opendocument.text-template":
    case "application/msword":
    case "application/rtf":
    case "application/x-mswrite":
    case "application/vnd.openxmlformats-officedocument.wordprocessingml.document":
    case "application/vnd.openxmlformats-officedocument.wordprocessingml.template":
    case "application/vnd.ms-works":
        return "writer"
    case "application/pdf":
        return "pdf"
    default:
        return "unknown"
    }
}
