/*
 * Copyright (c) 2022 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <QQmlExtensionPlugin>
#include <QtQml>

#include <basedocument.h>
#include "docview.h"
#include "bookmarksmodel.h"
#include "fileinfo.h"

class Q_DECL_EXPORT DocViewerPlugin : public QQmlExtensionPlugin
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "ru.omp.docviewer")
public:
    void initializeEngine(QQmlEngine *engine, const char *uri) override
    {
        Q_UNUSED(uri)
        Q_UNUSED(engine)
    }

    void registerTypes(const char *uri) override
    {
        // @uri ru.omp.docviewer
        qmlRegisterType<DocView>(uri, 1, 0, "DocViewPrivate");
        qmlRegisterType<BookmarksModel>(uri, 1, 0, "BookmarksModel");
        qmlRegisterType<FileInfo>(uri, 1, 0, "FileInfo");
        qmlRegisterInterface<BaseDocument>("BaseDocument");
    }
};

#include "plugin.moc"
