/*
 * Copyright (c) 2022 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#pragma once

#include <QQuickItem>
#include <QImage>

class BasePage;
class QTimer;
class QSGTexture;
class QPropertyAnimation;
class PageTile;

class MultiPageTile : public QQuickItem
{
    Q_OBJECT

    Q_PROPERTY(bool renderable READ renderable WRITE setRenderable NOTIFY renderableChanged)

public:
    explicit MultiPageTile(QQuickItem *parent = nullptr);
     ~MultiPageTile() override;

    QSGNode *updatePaintNode(QSGNode *oldNode, UpdatePaintNodeData *) override;
    void geometryChanged(const QRectF &newGeometry, const QRectF &oldGeometry) override;

    void setPageSource(QSharedPointer<BasePage> pageSource);
    bool renderable() const;
    bool isBitmap() const;
    void setTileSize(quint16 newTileSize);
    void setDebugIndex(int newDebugIndex);
    int debugIndex() const;

public slots:
    void setImageScale(qreal imageScale);
    void render(bool force = false);
    void setRenderable(bool renderable);

signals:
    void bitmapError();
    void partReady();
    void animationEnded();
    void renderableChanged(bool renderable);

private slots:
    void _tailorise();

private:
    QImage m_pagePart;
    QSharedPointer<BasePage> m_pageSource;
    bool m_renderable;
    qreal m_imageScale;
    QHash<int, PageTile *> m_tilesMap;
    quint16 m_tileSize;
    int m_debugIndex;
};
