/*
 * Copyright (c) 2022 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#pragma once

#include <QQuickItem>
#include <QSizeF>
#include <QPointF>
#include <QHash>

#include "docviewtypes.h"

class BaseDocument;
class DocumentMapper : public QQuickItem
{
    Q_OBJECT

public:
    explicit DocumentMapper(QQuickItem *parent = nullptr);

    QSGNode *updatePaintNode(QSGNode *, UpdatePaintNodeData *) override;

    QHash<int, PagePosition> actualMap() const;
    PagePosition actualPagePosition(int pageIndex) const;
    PageGeometry originalPageGeometry(int pageIndex) const;
    QPointF pagePosition(int pageIndex) const;
    QPointF mapToPage(const QPointF &pos, qreal scale) const;
    qreal contentHeight() const;
    qreal contentWidth() const;
    qreal spacing() const;
    qreal lastPageActualSize() const;
    int pageIndexAtPosition(const QPointF &actualPosition, qreal scale) const;
    int pageIndexAtPosition(const QPointF &originalPosition) const;
    void forceUpdate();

public slots:
    void setDocumentProvider(BaseDocument *documentProvider);
    void setOrientation(Qt::Orientation orientation);

signals:
    void contentWidthChanged(qreal);
    void contentHeightChanged(qreal);
    void mapEnd();

private slots:
    void _mapPages();
    void _updateSize();

private:
    BaseDocument *m_documentProvider;
    PagesMap m_originalPagesMap;
    QHash<int, PagePosition> m_actualPagesCoordinates;
    Qt::Orientation m_orientation;
    qreal m_spacing;
    qreal m_contentHeight;
    qreal m_contentWidth;
    qreal m_lastPageActualSize;
};
