/*
 * Copyright (c) 2022 - 2023 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#pragma once

#include <QQuickItem>
#include <QImage>

#include "basedocitem.h"

class QSGTexture;
class DocItemSearchHighlight : public BaseDocItem
{
    Q_OBJECT
public:
    DocItemSearchHighlight(const QColor &color, QQuickItem *parent = nullptr, BaseAnnotation *source = nullptr);
    bool event(QEvent *event) override;
    void setColor(const QColor &newColor) override;
};
