/*
 * Copyright (c) 2022 - 2023 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <QQuickWindow>
#include <QSGSimpleTextureNode>

#include "baseannotation.h"
#include "docitemsearchhighlight.h"

namespace {
int ALPHA_COLOR_BASE = 85;
int ALPHA_COLOR_SEARCH = 127;
int ALPHA_COLOR_SELECTION = 50;
}


DocItemSearchHighlight::DocItemSearchHighlight(const QColor &color, QQuickItem *parent, BaseAnnotation *source)
    : BaseDocItem(QColor(color.red(), color.green(), color.blue(), ALPHA_COLOR_BASE), QColor(), parent, source)
{
    if (source->type == BaseAnnotation::AnnotationType::CurrentSearch)
        BaseDocItem::setColor(QColor(color.red(), color.green(), color.blue(), ALPHA_COLOR_SEARCH));
    if (source->type == BaseAnnotation::AnnotationType::TextSelected)
        BaseDocItem::setColor(QColor(color.red(), color.green(), color.blue(), ALPHA_COLOR_SELECTION));
}

bool DocItemSearchHighlight::event(QEvent *event)
{
    return QQuickItem::event(event);
}

void DocItemSearchHighlight::setColor(const QColor &newColor)
{
    if (source()->type == BaseAnnotation::AnnotationType::CurrentSearch) {
        BaseDocItem::setColor(QColor(newColor.red(), newColor.green(), newColor.blue(), ALPHA_COLOR_SEARCH));
    } else if (source()->type == BaseAnnotation::AnnotationType::TextSelected) {
        BaseDocItem::setColor(QColor(newColor.red(), newColor.green(), newColor.blue(), ALPHA_COLOR_SELECTION));
    } else {
        BaseDocItem::setColor(QColor(newColor.red(), newColor.green(), newColor.blue(), ALPHA_COLOR_BASE));
    }
}

