/*
 * Copyright (c) 2022 - 2023 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "baseannotation.h"

#include "docitemcellselected.h"

namespace {
int ALPHA_COLOR = 50;
int ALPHA_HIGHLIGHT_COLOR = 121;
}

DocItemCellSelected::DocItemCellSelected(const QColor &color, QQuickItem *parent, BaseAnnotation *source)
    : BaseDocItem(QColor(color.red(), color.green(), color.blue(), ALPHA_COLOR), QColor(color.red(), color.green(), color.blue(), ALPHA_HIGHLIGHT_COLOR), parent, source)
{

}

void DocItemCellSelected::setColor(const QColor &newColor)
{
    BaseDocItem::setColor(QColor(newColor.red(), newColor.green(), newColor.blue(), ALPHA_COLOR));
    setHighlightcolor(QColor(newColor.red(), newColor.green(), newColor.blue(), ALPHA_HIGHLIGHT_COLOR));
}

