/*
 * Copyright (c) 2022 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <basebookmark.h>
#include "bookmarksmodel.h"

BookmarksModel::BookmarksModel(QObject *parent) : QAbstractListModel(parent) {  }

int BookmarksModel::rowCount(const QModelIndex &parent) const
{
    return parent.isValid() ? 0 : m_data.size();
}

QVariant BookmarksModel::data(const QModelIndex &index, int role) const
{
    if (!index.isValid() || index.row() >= m_data.size())
        return {  };

    const auto *bookmark = m_data.at(index.row());
    if (bookmark == nullptr)
        return {  };

    switch (role) {
    case LevelRole : return QVariant::fromValue(bookmark->level);
    case TitleRole: return QVariant::fromValue(bookmark->title);
    case PageIndexRole: return QVariant::fromValue(bookmark->pageIndex);
    case InPageXRole: return QVariant::fromValue(bookmark->positionInPage.x());
    case InPageYRole: return QVariant::fromValue(bookmark->positionInPage.y());
    }

    return {  };
}

QHash<int, QByteArray> BookmarksModel::roleNames() const
{
    return {
        { LevelRole, "level" },
        { TitleRole, "title" },
        { PageIndexRole, "pageIndex" },
        { InPageXRole, "pageX" },
        { InPageYRole, "pageY" }
    };
}

void BookmarksModel::setNewData(const QVector<BaseBookmark *> &newData)
{
    beginResetModel();
    m_data.clear();
    m_data = newData;
    endResetModel();
}
