/*
 * Copyright (c) 2022 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#pragma once

#include <QObject>
#include <QRunnable>
#include <QSharedPointer>
#include <QImage>
#include <QFutureWatcher>
#include <QMutex>

class BasePage;
class BitmapLoaderWorker : public QObject, public QRunnable
{
    Q_OBJECT

public:
    BitmapLoaderWorker(QSharedPointer<BasePage> p, qreal scaleX, qreal scaleY, int flags, qreal zoom = 1.0, QPointF bias = QPointF(), qreal pageScale = 1.0);
    ~BitmapLoaderWorker() override;

    void run() override;

public slots:
    void cancel();

signals:
    void done(QImage);

private slots:
    void _getResult();

private:
    QSharedPointer<BasePage> m_page;
    QFutureWatcher<QImage> m_watcher;
    qreal m_scaleX;
    qreal m_scaleY;
    int m_flags;
    qreal m_zoom;
    QPointF m_bias;
    qreal m_pageScale;
    static QMutex m_mutex;
    std::atomic<bool> m_isCanceled;
    std::atomic<bool> m_loaded;
};
