/*
 * Copyright (c) 2022 - 2023 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#pragma once

#include <QQuickItem>
#include <QImage>

struct BaseAnnotation;
class BaseDocItem: public QQuickItem
{
    Q_OBJECT
public:
    BaseDocItem(const QColor &color, const QColor &highlightcolor, QQuickItem *parent = nullptr, BaseAnnotation *source = nullptr);
    BaseAnnotation *source() const;
    QSGNode *updatePaintNode(QSGNode *oldNode, UpdatePaintNodeData *) override;
    const QColor &color() const;
    const QColor &highlightcolor() const;
    bool highlighted() const;

public slots:
    bool event(QEvent *event) override;
    void clearHighlight();
    void setHighlight(bool highlight);
    virtual void setColor(const QColor &newColor);
    void setHighlightcolor(const QColor &newHighlightcolor);

signals:
    void triggered(BaseAnnotation *);

protected:
    bool m_needUpdateImage;
    QImage m_paper;

private:
    BaseAnnotation *m_source;
    bool m_highlighted;
    QColor m_color;
    QColor m_highlightcolor;
};
