/*
 * Copyright (C) 2023 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 2.0
import Sailfish.Silica 1.0

Rectangle {
    id: cursor

    property bool toggled
    readonly property alias active: timer.running
    property Item editor: parent
    property QtObject preedit
    property real scale: 1.0

    property bool _blinkEnabled: true

    onActiveChanged: if (active) toggled = true

    function reset() {
        if (active) {
            timer.restart()
            toggled = true
        }
    }

    visible: active && (toggled || !_blinkEnabled)
    color: Theme.highlightColor
    width: Math.floor(Theme.dp(2) * Math.max(1.0, scale * 0.5))

    Timer {
        id: timer
        repeat: true
        interval: 800 // TODO: use Qt.styleHints.cursorFlashTime ?
        running: Qt.application.active
        onTriggered: toggled = !toggled
    }
}
