/*
 * Copyright (C) 2021 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 2.4
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0

Rectangle {
    property real zoom: 1.0

    function show() {
        opacity = 1.0
        timer.start()
    }

    opacity: 0.0
    visible: opacity
    color: Qt.tint(Theme.darkPrimaryColor, Theme.rgba(Theme.lightPrimaryColor, Theme.opacityFaint))
    radius: Theme.paddingSmall
    height: label.height + Theme.paddingLarge
    width: label.width + Theme.paddingLarge

    onZoomChanged: show()

    Behavior on opacity { FadeAnimation { } }

    Label {
        id: label
        anchors.centerIn: parent
        text: ("%1%").arg(Math.round(zoom * 100))
        font.pixelSize: Theme.fontSizeSmall
        font.family: "Courier"
        color: Theme.lightPrimaryColor
    }

    Timer {
        id: timer
        interval: 2500
        onTriggered: opacity = 0.0
    }
}
