/*
 * Copyright (с) 2022 Open Mobile Platform LLC.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 2.0
import Sailfish.Silica 1.0

ProgressBar {
    id: progressBar

    property var document

    width: parent.width
    minimumValue: 0
    maximumValue: 100
    indeterminate: !(document.loadingProgress > 0 && document.loadingProgress < 100)
    value: document.loadingProgress

    anchors.verticalCenter: parent.verticalCenter

    Text {

        color: progressBar.highlighted ? palette.secondaryHighlightColor
                                       : palette.secondaryColor
        textFormat: Text.PlainText
        text: progressBar.indeterminate ? (document.loadingProgress === 0 ? //% "Preparing to load"
                                                                                 qsTrId("docviewer-la-preparing")
                                                                               : //% "Opening document"
                                                                                 qsTrId("docviewer-la-opening"))
                                        : //% "Loading document"
                                          qsTrId("docviewer-la-loading")

        font { pixelSize: Theme.fontSizeSmall; family: Theme.fontFamily }
        anchors { verticalCenter: parent.bottom; horizontalCenter: parent.horizontalCenter }
    }
}
