/*
 * Copyright (C) 2021 - 2023 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0

Rectangle {
    property bool processing
    property alias text: label.text
    property bool _show

    onProcessingChanged: {
        if (processing) {
            _show = true
            timer.stop()
        } else {
            timer.start()
        }
    }

    color: Theme.darkPrimaryColor
    width: parent.width
    height: _show ? label.height + Theme.paddingMedium : 0
    opacity: _show ? 1.0 : 0.0

    Behavior on height { NumberAnimation { duration:  300 } }
    Behavior on opacity { FadeAnimation { } }

    BusyIndicator {
        id: indicator

        anchors {
            left: parent.left
            leftMargin: Theme.paddingLarge * 2
            verticalCenter: parent.verticalCenter
        }

        running: _show
        size: BusyIndicatorSize.Small
        color: Theme.lightPrimaryColor
    }

    Label {
        id: label

        anchors {
            left: indicator.right
            leftMargin: Theme.paddingMedium
            verticalCenter: parent.verticalCenter
        }

        color: Theme.lightPrimaryColor
        font.pixelSize: Theme.fontSizeSmall
        //% "Loading"
        text: qsTrId("docviewer-la-processing")
    }

    Timer {
        id: timer

        interval: 1500
        onTriggered: _show = false
    }
}
