/*
 * Copyright (с) 2022 - 2023 Open Mobile Platform LLC.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 2.2
import Sailfish.Silica 1.0

Item {
    id: root

    property int horizontalOffset
    property var desktopBookmarkWriter
    property bool enabledSearch: true
    property bool enabledExportPdf: true
    readonly property int verticalPadding: 3 * Theme.paddingSmall
    readonly property int iconWidth: Theme.iconSizeMedium + Theme.paddingLarge

    signal searchClicked
    signal shareClicked
    signal infoClicked
    signal exportToPdf
    signal printClicked
    signal saveAsClicked

    height: content.height + verticalPadding * 2

    Column {
        id: content
        width: parent.width
        spacing: Theme.paddingLarge
        y: verticalPadding

        Column {
            width: parent.width

            OverlayListItem {
                onClicked: {
                    popupMenu.closed()
                    root.searchClicked()
                }
                enabled: root.enabledSearch
                height: Theme.itemSizeSmall
                iconWidth: root.iconWidth
                iconSource: "image://theme/icon-m-search"
                //% "Search by document"
                text: qsTrId("docviewer-la-search_by_doc")
            }

            OverlayListItem {
                onClicked: {
                    popupMenu.closed()
                    root.shareClicked()
                }
                height: Theme.itemSizeSmall
                iconWidth: root.iconWidth
                iconSource: "image://theme/icon-m-share"
                //% "Share"
                text: qsTrId("docviewer-la-share")
            }

            OverlayListItem {
                onClicked: {
                    popupMenu.closed()
                    root.exportToPdf()
                }
                enabled: enabledExportPdf
                height: Theme.itemSizeSmall
                iconWidth: root.iconWidth
                iconSource: "image://theme/icon-m-file-download-as-pdf"
                //% "Export to PDF"
                text: qsTrId("docviewer-la-export_to_pdf")
            }

            OverlayListItem {
                onClicked: {
                    popupMenu.closed()
                    root.printClicked()
                }
                enabled: enabledExportPdf
                height: Theme.itemSizeSmall
                iconWidth: root.iconWidth
                iconSource: "image://theme/icon-m-print"
                //% "Print"
                text: qsTrId("docviewer-la-print")
            }

            OverlayListItem {
                onClicked: {
                    popupMenu.closed()
                    root.saveAsClicked()
                }
                enabled: enabledExportPdf
                height: Theme.itemSizeSmall
                iconWidth: root.iconWidth
                iconSource: "image://theme/icon-m-save"
                //% "Save as"
                text: qsTrId("docviewer-la-save_as")
            }

            OverlayListItem {
                onClicked: {
                    popupMenu.closed()
                    root.infoClicked()
                }
                height: Theme.itemSizeSmall
                iconWidth: root.iconWidth
                iconSource: "image://theme/icon-m-about"
                //% "Document Information"
                text: qsTrId("docviewer-la-doc_info")
            }
        }
    }
}
