/*
 * Copyright (с) 2022 Open Mobile Platform LLC.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 2.2
import Sailfish.Silica 1.0

Item {
    id: root

    property var popupMenu
    property alias url: linkTarget.text
    readonly property int verticalPadding: 3 * Theme.paddingMedium

    signal closeMenu

    height: content.height + verticalPadding * 2

    Column {
        id: content

        width: parent.width
        spacing: Theme.paddingLarge
        y: verticalPadding

        InfoLabel {
            id: linkTarget

            font.pixelSize: Theme.fontSizeMedium
            wrapMode: Text.Wrap
            elide: Text.ElideRight
            maximumLineCount: 5
            color: Theme.highlightColor
            opacity: Theme.opacityHigh
        }

        Column {
            width: parent.width

            OverlayListItem {
                onClicked: {
                    closeMenu()
                    Qt.openUrlExternally(root.url)
                }
                text: (root.url.indexOf("http:") === 0
                       || root.url.indexOf("https:") === 0)
                      //% "Open in browser"
                      ? qsTrId("docviewer-me-link_open_browser")
                        //% "Open in external application"
                      : qsTrId("docviewer-me-link_open_external")
                horizontalAlignmentText: Text.AlignHCenter
            }
            OverlayListItem {
                onClicked: {
                    closeMenu()
                    Clipboard.text = root.url
                    //% "Сopied"
                    Notices.show(qsTrId("docviewer-me-copied_link"))
                }
                //% "Copy to clipboard"
                text: qsTrId("docviewer-me-copy_link")
                horizontalAlignmentText: Text.AlignHCenter
            }
            OverlayListItem {
                onClicked: closeMenu()
                //% "Cancel"
                text: qsTrId("docviewer-me-cancel")
                horizontalAlignmentText: Text.AlignHCenter
            }
        }
    }
}
