/*
 * Copyright (с) 2022 Open Mobile Platform LLC.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 2.2
import Sailfish.Silica 1.0

Rectangle {
    id: root

    property string text
    readonly property real overlayOpacity: 0.15

    signal closeMenu

    height: Theme.itemSizeMedium - Theme.paddingMedium
    implicitWidth: content.width
    color: Qt.tint(
               Theme.colorScheme === Theme.LightOnDark ? "black" : "white",
               Theme.rgba(Theme.primaryColor, root.overlayOpacity))

    Row {
        id: content

        height: root.height
        width: root.width

        OverlayListItem {
            onClicked: {
                Clipboard.text = root.text
                //% "Сopied"
                Notices.show(qsTrId("docviewer-me-copied_link"), Notice.Long, Notice.Center)
            }
            width: parent.width / 2
            //% "Copy"
            text: qsTrId("docviewer-me-copy")
            horizontalAlignmentText: Text.AlignHCenter
        }
        OverlayListItem {
            onClicked: closeMenu()
            width: parent.width / 2
            //% "Close"
            text: qsTrId("docviewer-me-close")
            horizontalAlignmentText: Text.AlignHCenter
        }
    }
}
