/*
 * Copyright (с) 2022 - 2023 Open Mobile Platform LLC.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 2.2
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private

Item {
    id: root

    property var popupMenu
    property alias content: textContent.text
    property bool isViewFull
    readonly property int verticalPadding: 3 * Theme.paddingMedium

    signal closeMenu

    height: content.height + verticalPadding * 2

    Column {
        id: content

        width: parent.width
        spacing: Theme.paddingLarge
        y: verticalPadding

        InfoLabel {
            id: textContent

            font.pixelSize: Theme.fontSizeMedium
            wrapMode: Text.Wrap
            elide: Text.ElideRight
            color: Theme.highlightColor
            opacity: Theme.opacityHigh
        }
    }
}
