/*
 * Copyright (с) 2021 - 2022 Open Mobile Platform LLC.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 2.6
import Sailfish.Silica 1.0

BackgroundItem {
    id: root

    property alias text: label.text
    property alias iconSource: icon.source
    property alias checked: toggle.checked
    property alias horizontalAlignmentText: label.horizontalAlignment
    property bool checkable
    property int horizontalOffset
    property int iconWidth

    width: parent.width

    Item {
        id: iconContainer

        width: iconWidth
        height: parent.height
        x: Theme.paddingMedium

        Icon {
            id: icon

            anchors {
                centerIn: parent
                horizontalCenterOffset: horizontalOffset
            }
            highlighted: root.highlighted
            color: Theme.primaryColor
            opacity: root.enabled ? 1.0 : Theme.opacityLow
        }
    }
    Label {
        id: label

        anchors {
            left: iconContainer.right
            leftMargin: Theme.paddingMedium
            right: parent.right
            rightMargin: toggle.visible ? toggle.width + Theme.paddingMedium : Theme.horizontalPageMargin
            verticalCenter: parent.verticalCenter
        }
        color: root.highlighted ? Theme.highlightColor : Theme.primaryColor
        opacity: root.enabled ? 1.0 : Theme.opacityLow
        truncationMode: TruncationMode.Fade

        Behavior on opacity { FadeAnimation {} }
    }
    Switch {
        id: toggle
        anchors {
            right: parent.right
            verticalCenter: parent.verticalCenter
        }

        visible: checkable
        onClicked: root.clicked(mouse)
    }
}
