/*
 * Copyright (C) 2019 Jolla Ltd.
 * Copyright (C) 2020-2021 Open Mobile Platform LLC.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 2.6
import Sailfish.Silica 1.0
import ru.omp.documentprovider.libreoffice 1.0

TouchBlocker {
    id: root

    property var provider

    property string _errorString: {
        switch (provider.error) {
        case LoDocumentProvider.EmptyUrl:
            //% "Can't open empty URL"
            return qsTrId("docviewer-la-error-empty-url")
        case LoDocumentProvider.FileNotFound:
            //% "File %1 not found"
            return qsTrId("docviewer-la-error-file-not-found").arg(decodeURI(provider.path))
        case LoDocumentProvider.UnsupportedFileType:
            //% "Unsupported type of file: %1"
            return qsTrId("docviewer-la-error-unsupported-file-type").arg(decodeURI(provider.path))
        case LoDocumentProvider.CorruptedDocument:
            if (_errorString === qsTrId("docviewer-la-error-unsupported-file-type").arg(decodeURI(provider.path)))
                return qsTrId("docviewer-la-error-unsupported-file-type").arg(decodeURI(provider.path))
            //% "The document could not be opened, it may be corrupted"
            return qsTrId("docviewer-la-error-corrupted-document")
        case LoDocumentProvider.ProviderContextError:
        case LoDocumentProvider.ProviderLoaderError:
        case LoDocumentProvider.ProviderProcessError:
            //% "Can't show the document"
            return qsTrId("docviewer-la-error-show-document")
        default:
            //% "Unknown error"
            return qsTrId("docviewer-la-error-unknown")
        }
    }

    anchors.fill: parent

    Rectangle {
        opacity: Theme.opacityLow
        color: Theme.highlightDimmerColor
        anchors.fill: parent
    }

    Column {
        x: Theme.horizontalPageMargin
        width: parent.width - 2 * x
        spacing: Theme.paddingMedium
        anchors.verticalCenter: parent.verticalCenter

        HighlightImage {
            id: warningIcon

            source: "image://theme/icon-l-attention"
            highlighted: true
            anchors.horizontalCenter: parent.horizontalCenter
        }

        Label {
            width: parent.width
            text: _errorString
            wrapMode: Text.Wrap
            color: Theme.highlightColor
            horizontalAlignment: Text.AlignHCenter
        }
    }
}
