/*
 * Copyright (c) 2022 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 2.6
import Sailfish.Silica 1.0

Page {
    id: root

    property alias author: author.value
    property alias dateTime: comment.label
    property alias text: comment.value

    allowedOrientations: Orientation.All

    SilicaFlickable {
        id: flickable

        contentHeight: contentColumn.height + Theme.paddingLarge
        anchors.fill: parent

        Column {
            id: contentColumn

            width: parent.width
            spacing: Theme.paddingMedium

            PageHeader {
                id: pageHeader

                //% "View note"
                title: qsTrId("docviewer-he-view_note")
            }

            DetailItem {
                id: author

                //% "Author"
                label: qsTrId("docviewer-la-author")
                alignment: Qt.AlignLeft
            }

            DetailItem {
                id: comment

                forceValueBelow: true
                alignment: Qt.AlignLeft
            }
        }
    }
}
