%define external_url https://dev-www.libreoffice.org/src/

%global __provides_exclude_from ^%{_datadir}/%{name}/lib/libreoffice/program/.*\\.so.*$
%global __requires_exclude_from ^%{_datadir}/%{name}/lib/libreoffice/program/.*$

Name:       ru.auroraos.OfficeViewer
Summary:    OfficeViewer App based on LibreOffice
Version:    0.0.1
Release:    1
License:    BSD-3-Clause
URL:        https://auroraos.ru
Source0:    %{name}-%{version}.tar.bz2

BuildRequires:  which
BuildRequires:  pkgconfig(libjpeg)
BuildRequires:  bsdtar
BuildRequires:  pkgconfig(hunspell)
BuildRequires:  pkgconfig(zlib)
BuildRequires:  pkgconfig(cairo)
BuildRequires:  pkgconfig(openssl)
BuildRequires:  pkgconfig(cppunit)
BuildRequires:  pkgconfig(libcrypt)
BuildRequires:  libtool-ltdl-devel
BuildRequires:  autoconf
BuildRequires:  libtool
BuildRequires:  zip
BuildRequires:  gperf
BuildRequires:  bison
BuildRequires:  flex >= 2.6.0
BuildRequires:  pkgconfig(zxing)
BuildRequires:  libcurl-devel
BuildRequires:  pkgconfig(libxslt)
BuildRequires:  pkgconfig(nss)
BuildRequires:  pkgconfig(egl)
BuildRequires:  libGLESv1-devel
BuildRequires:  libGLESv2-devel
BuildRequires:  pkgconfig(auroraapp)
BuildRequires:  pkgconfig(Qt5Core)
BuildRequires:  pkgconfig(Qt5Qml)
BuildRequires:  pkgconfig(Qt5Quick)
BuildRequires:  pkgconfig(Qt5Concurrent)
BuildRequires:  desktop-file-utils

Requires:   sailfishsilica-qt5 >= 0.10.9
Requires:   nemo-qml-plugin-configuration-qt5

Patch1:     0001-configure-fix-tar-checking.patch
Patch2:     0002-disable-sane-checking.patch
Patch3:     0003-hack-required-gperf-version.patch
Patch4:     0004-use-egl-epoxy.patch

%description
%{summary}.

%package -n documentprovider-base
Summary: Base component for documentprovider plugins
Obsoletes: documentprovider-core < 0.3.0
Obsoletes: documentprovider-poppler < 0.3.0

%description -n documentprovider-base
%{summary}. Provides asbtract DocumentProvider class.

%package -n documentprovider-devel
Summary: Header files for documentprovider plugins

%description -n documentprovider-devel
%{summary}.

%package qml-plugin
Summary:  Documentprovider viewer component
Requires: documentprovider-base = %{version}
Obsoletes: documentprovider-viewer < 0.3.0

%description qml-plugin
%{summary}.


%package -n documentprovider-libreoffice
Summary: libreoffice documentprovider plugin
Requires: documentprovider-base = %{version}
Requires: libreoffice

%description -n documentprovider-libreoffice
%{summary}.

%prep
%autosetup -p1 -n %{name}-%{version}/upstream

%build
# path to external tarballs
EXTSRCDIR=../tarballs
LDFLAGS=-Wl,-rpath=%{_datadir}/%{name}/lib

aclocal -I ${PWD}/m4
autoconf -I ${PWD}
%configure \
--without-help \
--without-helppack-integration \
--without-myspell-dicts \
--without-system-dicts \
--without-doxygen \
--without-java \
--without-krb5 \
--without-fonts \
--without-junit \
--without-galleries \
--without-theme \
--without-package-format \
--without-system-libcmis \
--without-system-cuckoo \
--without-system-clucene \
--without-system-xmlsec \
--without-system-libodfgen \
--without-system-libepubgen \
--without-system-libwpd \
--without-system-libwpg \
--without-system-libwps \
--without-system-libvisio \
--without-system-libcdr \
--without-system-libmspub \
--without-system-libmwaw \
--without-system-libetonyek \
--without-system-libfreehand \
--without-system-libebook \
--without-system-libabw \
--without-system-libpagemaker \
--without-system-libqxp \
--without-system-libzmf \
--without-system-libstaroffice \
--without-system-mdds \
--without-system-orcus \
--without-system-redland \
--without-system-mythes \
--without-system-glm \
--without-system-libexttextcat \
--without-system-libnumbertext \
--without-system-altlinuxhyph \
--without-system-box2d \
--without-system-librevenge \
--without-system-odbc \
--without-system-liblangtag \
--without-system-epoxy \
--without-system-harfbuzz \
--without-system-boost \
--without-system-graphite \
--without-system-lcms2 \
--without-system-icu \
--disable-cmis \
--disable-odk \
--disable-gtk3 \
--disable-gtk4 \
--disable-gio \
--disable-qt5 \
--disable-gui \
--disable-randr \
--disable-cairo-canvas \
--disable-dbus \
--disable-cups \
--disable-dconf \
--disable-ldap \
--disable-report-builder \
--disable-coinmp \
--disable-lpsolve \
--disable-lotuswordpro \
--disable-scripting-beanshell \
--disable-scripting-javascript \
--disable-sdremote \
--disable-postgresql-sdbc \
--disable-firebird-sdbc \
--disable-pdfimport \
--disable-pdfium \
--disable-poppler \
--disable-skia \
--disable-evolution2 \
--disable-fuzzers \
--disable-cve-tests \
--disable-chart-tests \
--disable-fetch-external \
--disable-dependency-tracking \
--disable-extension-update \
--disable-extension-integration \
--disable-ooenv \
--disable-debug \
--disable-dbgutil \
--with-system-libs \
--with-system-ucpp \
--with-lang="" \
--with-locales="" \
--with-webdav=no \
--with-theme=no \
--enable-ld=gold \
--with-vendor="Open Mobile Platform LLC" \
--disable-fetch-external \
--with-external-tar="$EXTSRCDIR" \
--without-system-sane \
--enable-mpl-subset \
--enable-release-build \
--enable-eot=no \
--enable-python=no \
--enable-mergelibs \
--with-parallelism=%(echo -n "%{?_smp_mflags}" | sed "s/-j//") \
--libexecdir=%{_libexecdir}/%{name} \
--libdir=%{_datadir}/%{name}/lib 
%define _smp_mflags %{nil}
%make_build build-nocheck

cd ..
%{__cp} -r upstream/include/LibreOfficeKit application/

%qmake5
%make_build

%install
BINDIR=../tarballs
%{__make} install-strip DESTDIR=%{?buildroot} INSTALL="%{__install} -p"
%{__rm} -f %{buildroot}/gid_Module_*
%{__install} -d %{buildroot}%{_datadir}/%{name}/include/LibreOfficeKit
%{__cp} -r ../upstream/include/LibreOfficeKit %{buildroot}%{_datadir}/%{name}/include
%{__mkdir_p} %{buildroot}%{_libexecdir}/%{name}
%{__rm} %{buildroot}%{_datadir}/%{name}/lib/libreoffice/program/gengal 
%{__rm} %{buildroot}%{_datadir}/%{name}/lib/libreoffice/program/senddoc 
%{__rm} %{buildroot}%{_datadir}/%{name}/lib/libreoffice/program/uno 
%{__rm} %{buildroot}%{_datadir}/%{name}/lib/libreoffice/program/unoinfo 
%{__rm} %{buildroot}%{_datadir}/%{name}/lib/libreoffice/program/unopkg 
chmod -x %{buildroot}%{_datadir}/%{name}/lib/libreoffice/program/gengal.bin
%{__rm} %{buildroot}%{_datadir}/%{name}/lib/libreoffice/program/oosplash 
%{__rm} %{buildroot}%{_datadir}/%{name}/lib/libreoffice/program/opencltest 
%{__rm} %{buildroot}%{_datadir}/%{name}/lib/libreoffice/program/regmerge 
%{__rm} %{buildroot}%{_datadir}/%{name}/lib/libreoffice/program/regview 
chmod -x %{buildroot}%{_datadir}/%{name}/lib/libreoffice/program/soffice.bin
chmod -x %{buildroot}%{_datadir}/%{name}/lib/libreoffice/program/uno.bin 
chmod -x %{buildroot}%{_datadir}/%{name}/lib/libreoffice/program/unopkg.bin 
%{__rm} %{buildroot}%{_datadir}/%{name}/lib/libreoffice/program/uri-encode 

cd ..
%qmake5_install

# %post
# update-desktop-database -q

# %postun
# update-desktop-database -q

# %post -n documentprovider-base -p /sbin/ldconfig

# %postun -n documentprovider-base -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%{_bindir}/%{name}
%defattr(644,root,root,-)
%{_datadir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/*/apps/%{name}.png

%files -n documentprovider-base
%defattr(-,root,root,-)
%{_libdir}/libdocumentprovider.so.*

%files -n documentprovider-devel
%defattr(-,root,root,-)
%{_includedir}/documentprovider
%{_libdir}/libdocumentprovider.so
%{_libdir}/libdocumentprovider.prl
%{_libdir}/pkgconfig/documentprovider.pc

%files qml-plugin
%defattr(-,root,root,-)
%{_libdir}/qt5/qml/ru/omp/docviewer

%files -n documentprovider-libreoffice
%defattr(-,root,root,-)
%{_libdir}/qt5/qml/ru/omp/documentprovider/libreoffice
%{_libexecdir}/libreoffice-worker
