/*
 * Copyright (c) 2020 - 2022 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <QQmlEngine>
#include <QQmlExtensionPlugin>
#include <QtQml>

#include "lodocumentprovider.h"
#include "lodocument.h"
#include "lopage.h"

class OmpOfficeViewerPlugin : public QQmlExtensionPlugin {
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "ru.omp.documentprovider.libreoffice")

public:
    virtual void registerTypes(const char* uri) {
        Q_ASSERT(QLatin1String(uri) == QLatin1String("ru.omp.documentprovider.libreoffice"));

        qmlRegisterType<LoDocumentProvider>(uri, 1, 0, "LoDocumentProvider");
        qmlRegisterType<LoDocument>(uri, 1, 0, "LoDocument");
    }
};

#include "plugin.moc"
