/*
 * Copyright (c) 2022 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#pragma once

#include <QObject>
#include <QRunnable>
#include <QSharedPointer>
#include <QMutex>

#include "basedocument.h"

class LoDocumentProvider;
class PagePreloader : public QObject, public QRunnable
{
    Q_OBJECT

public:
    PagePreloader(QSharedPointer<LoDocumentProvider> document, int pageIndex);
    ~PagePreloader() override;

    void run() override;

signals:
    void done(int, BaseDocument::PageLoadStatus);

private:
    QSharedPointer<LoDocumentProvider> m_document;
    int m_pageIndex;
    static QMutex m_mutex;
};
