/*
 * Copyright (c) 2022 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#pragma once

#include <QObject>
#include <QSharedPointer>

#include <basepage.h>

class LoPageProvider;
class LoDocument;
class BaseDocument;

class LoPage : public BasePage
{
    Q_OBJECT
public:
    explicit LoPage(QSharedPointer<LoPageProvider> loPageProvider, BaseDocument *document = nullptr);
    ~LoPage();

    QThreadPool *threadPool() const override;
    QList<BaseAnnotation *> annotations() const override;
    void loadAnnotations() override;
    bool isAnnotationsSupport() const override;
    int pageIndex() const override;
    QFuture<QSizeF> originalSize() override;
    QFuture<QImage> bitmapFull(qreal pageScale, int renderFlags = 0) const override;
    QFuture<QImage> bitmapPart(qreal pageScaleX, qreal pageScaleY,
                                       int renderFlags = 0, qreal zoom = 1.0,
                                       const QPointF &bias = QPointF(),
                                       qreal pageScale = 1.0) const override;
    void addAnnotation(const QRectF &rect, const QColor &color,
                                   const QString &author, const QString &content) override;
    void stopBitmapPart(qreal pageScaleX, qreal pageScaleY, qreal zoom = 1.0,
                                const QPointF &bias = QPointF()) override;
    void stopAllBitmapPart() override;
    BaseDocumentProvider::DocumentType documentType() const override;

private:
    QList<BaseAnnotation *> m_annotations;
    QSharedPointer<LoPageProvider> m_loPageProvider;
    LoDocument *m_loDocument;
};
